﻿var questionTranslationEditor = {
    context: $(".v-translateVariables"),
    questionnaireId: 0,
    bindEvents: function () {
        questionTranslationEditor.context.on("click", ".v-switchQuestion", function () {
            questionTranslationEditor.switchQuestion($(this).attr("data-type"));
        });

        questionTranslationEditor.context.on("click", ".v-saveQuestion", function () {
            $.when(questionTranslationEditor.saveQuestion()).then(function () { modalDialog.close(); });
        });

        questionTranslationEditor.context.on("click", ".v-saveQuestionAndNext", function () {
            $.when(questionTranslationEditor.saveQuestion()).then(function () {
                questionTranslationEditor.switchQuestion("next");
            });
        });

        $(".v-translateLanguage, .v-referenceLanguage, .v-questionSelector", questionTranslationEditor.context).each(function () {
            $(this).data("prev", $(this).val());
        });

        questionTranslationEditor.context.on("change", ".v-translateLanguage, .v-referenceLanguage, .v-questionSelector", function () {
            var select = $(this);
            var currentValue = select.val();
            var previousValue = select.data("prev");

            if (questionTranslationEditor.hasUnsavedChanges())
            {
                modalDialog.showUnsavedChangesDialog(function () {
                    select.val(previousValue);
                    $.when(questionTranslationEditor.saveQuestion())
                     .then(function () {
                         select.val(currentValue);
                         select.data("prev", currentValue);
                         questionTranslationEditor.updateQuestionEditor();
                     });
                }, function () {
                    select.data("prev", currentValue);
                    questionTranslationEditor.updateQuestionEditor();
                }, function () {
                    select.val(previousValue);
                });
            }
            else
            {
                select.data("prev", currentValue);
                questionTranslationEditor.updateQuestionEditor();
            }
        });

        questionTranslationEditor.context.on("change", ".v-translationTextBox", function () {
            $(this).attr("data-changed", "true");
        });
    },
    switchQuestion: function (type) {
        var $questionsMenu = $(".v-questionSelector", questionTranslationEditor.context);
        var $selectedOption = $questionsMenu.find(":selected");
        var $switchToOption = type == "next" ? $selectedOption.next($("option", $questionsMenu)) : $selectedOption.prev($("option", $questionsMenu));

        if ($switchToOption.length > 0)
        {
            $questionsMenu.val($switchToOption.val());
            $questionsMenu.trigger("change");
        }
    },
    updateQuestionEditor: function () {
        var translationEdition = $("#questionTranslationEditor .v-translatorContainer", questionTranslationEditor.context);

        var args = {
            variable: $(".v-questionSelector", questionTranslationEditor.context).val(),
            referenceLanguage: $(".v-referenceLanguage", questionTranslationEditor.context).val(),
            translationLanguage: $(".v-translateLanguage", questionTranslationEditor.context).val()
        }

        a4.callServerMethod(a4.getAction("GetTranslateVariableEditor", "Home", "Project", { questionnaireId: questionTranslationEditor.questionnaireId }), args, function (result) {
            translationEdition.empty().append(result);
        });
    },
    saveQuestion: function () {
        var variable = { Name: $(".v-questionSelector", questionTranslationEditor.context).val() };
        var translatorContainer = $(".v-translatorContainer", questionTranslationEditor.context);
        var promise = null;

        if (questionTranslationEditor.hasUnsavedChanges())
        {
            $(".v-variableText", translatorContainer).each(function () {
                variable[$(this).attr("data-key")] = $(this).val() || "";
            });

            variable.Choices = $(".v-choiceText", translatorContainer).map(function () {
                return { Code: $(this).attr("data-key"), Label: $(this).val() };
            }).get();

            var args = {
                questionnaireId: questionTranslationEditor.questionnaireId,
                variable: variable,
                language: $(".v-translateLanguage", questionTranslationEditor.context).val()
            };

            promise = a4.callServerMethod(a4.getAction("UpdateVariable", "Home", "Project"), args, function (result) {
                a4.showSuccessMessage(resources.SuccessMessage, 2000);
                questionTranslationEditor.clearUnsavedChanges();
            });
        }

        return promise;
    },
    hasUnsavedChanges: function () {
        return $(".v-translationTextBox[data-changed='true']", questionTranslationEditor.context).length > 0;
    },
    clearUnsavedChanges: function () {
        return $(".v-translationTextBox[data-changed='true']", questionTranslationEditor.context).attr("data-changed", "false");
    },
}

$(document).ready(function () {
    if (questionTranslationEditor.context.length > 0)
    {
        questionTranslationEditor.questionnaireId = $("#QuestionnaireId", questionTranslationEditor.context).val();
        questionTranslationEditor.bindEvents();
    }
});
